/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.faulttests;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;

public class SequenceTimedOutTest
extends SandeshaTestCase {
    private static final String server_repoPath = "target" + File.separator + "repos" + File.separator + "server";
    private static final String server_axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";

    public SequenceTimedOutTest() {
        super("SequenceTimedOutTest");
    }

    public void setUp() throws Exception {
        super.setUp();
    }

    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSOAP11CreateSequenceRefusedInboundFault() throws Exception {
        String to = "http://127.0.0.1:9999/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        HashMap axisServices = configContext.getAxisConfiguration().getServices();
        AxisService service = null;
        Iterator values = axisServices.values().iterator();
        while (values.hasNext()) {
            service = (AxisService)values.next();
        }
        Iterator operations = service.getOperations();
        while (operations.hasNext()) {
            AxisOperation op = (AxisOperation)operations.next();
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)op);
            if (propertyBean == null) continue;
            propertyBean.setInactiveTimeoutInterval(1L, "seconds");
        }
        String acksTo = "http://www.w3.org/2005/08/addressing/none";
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        serviceClient.setOptions(clientOptions);
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(SequenceTimedOutTest.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SequenceTimedOutTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)4);
                SequenceTimedOutTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                SequenceTimedOutTest.assertTrue((boolean)callback1.isErrorReported());
                SequenceTimedOutTest.assertEquals((String)callback1.getResult(), null);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    public void testRMSSequenceTimeoutSequenceDeleted() throws Exception {
        String to = "http://127.0.0.1:9999/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        HashMap axisServices = configContext.getAxisConfiguration().getServices();
        AxisService service = null;
        Iterator values = axisServices.values().iterator();
        while (values.hasNext()) {
            service = (AxisService)values.next();
        }
        Iterator operations = service.getOperations();
        while (operations.hasNext()) {
            AxisOperation op = (AxisOperation)operations.next();
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)op);
            if (propertyBean == null) continue;
            propertyBean.setInactiveTimeoutInterval(1L, "seconds");
            propertyBean.setSequenceRemovalTimeoutInterval(2L, "seconds");
        }
        String acksTo = "http://www.w3.org/2005/08/addressing/none";
        clientOptions.setProperty(SandeshaClientConstants.AcksTo, (Object)acksTo);
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        clientOptions.setProperty(SandeshaClientConstants.LAST_MESSAGE, (Object)"true");
        serviceClient.setOptions(clientOptions);
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback("Callback 1");
        serviceClient.sendReceiveNonBlocking(SequenceTimedOutTest.getEchoOMBlock("echo1", sequenceKey), (AxisCallback)callback1);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SequenceTimedOutTest.assertEquals((byte)sequenceReport.getSequenceStatus(), (byte)4);
                SequenceTimedOutTest.assertEquals((byte)sequenceReport.getSequenceDirection(), (byte)2);
                SequenceTimedOutTest.assertTrue((boolean)callback1.isErrorReported());
                SequenceTimedOutTest.assertEquals((String)callback1.getResult(), null);
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)configContext, (AxisDescription)configContext.getAxisConfiguration());
            Transaction tran = storageManager.getTransaction();
            RMSBean finderBean = new RMSBean();
            List rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
            tran.commit();
            lastError = null;
            if (rmsBeans.isEmpty()) break;
            lastError = new Error("rmsBeans not empty " + rmsBeans);
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    public void testRMDSequenceTerminatedDeleted() throws Exception {
        List rmdBeans;
        RMDBean finderBean;
        Transaction tran;
        StorageManager storageManager;
        ConfigurationContext serverConfigContext = this.startServer(server_repoPath, server_axis2_xml);
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setTo(new EndpointReference(to));
        String sequenceKey = SandeshaUtil.getUUID();
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        serviceClient.setOptions(clientOptions);
        HashMap axisServices = serverConfigContext.getAxisConfiguration().getServices();
        AxisService service = null;
        Iterator values = axisServices.values().iterator();
        while (values.hasNext()) {
            service = (AxisService)values.next();
        }
        Iterator operations = service.getOperations();
        while (operations.hasNext()) {
            AxisOperation op = (AxisOperation)operations.next();
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean((AxisDescription)op);
            if (propertyBean == null) continue;
            propertyBean.setInactiveTimeoutInterval(2L, "seconds");
            propertyBean.setSequenceRemovalTimeoutInterval(2L, "seconds");
        }
        serviceClient.fireAndForget(this.getPingOMBlock("ping1"));
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)serverConfigContext, (AxisDescription)serverConfigContext.getAxisConfiguration());
            tran = storageManager.getTransaction();
            finderBean = new RMDBean();
            rmdBeans = storageManager.getRMDBeanMgr().find(finderBean);
            tran.commit();
            lastError = null;
            if (rmdBeans.isEmpty()) {
                lastError = new Error("rmdBeans empty " + rmdBeans);
                continue;
            }
            RMDBean bean = (RMDBean)rmdBeans.get(0);
            if (bean.isTerminated()) break;
            lastError = new Error("RMDBean not deleted " + bean);
        }
        if (lastError != null) {
            throw lastError;
        }
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            storageManager = SandeshaUtil.getSandeshaStorageManager((ConfigurationContext)serverConfigContext, (AxisDescription)serverConfigContext.getAxisConfiguration());
            tran = storageManager.getTransaction();
            finderBean = new RMDBean();
            rmdBeans = storageManager.getRMDBeanMgr().find(finderBean);
            tran.commit();
            lastError = null;
            if (rmdBeans.isEmpty()) break;
            lastError = new Error("rmdBeans not empty " + rmdBeans);
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

