/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.mtom;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.namespace.QName;
import junit.framework.Assert;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.receivers.RawXMLINOnlyMessageReceiver;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.SandeshaTestCase;

public class MTOMRMTest
extends SandeshaTestCase {
    SimpleHTTPServer httpServer = null;
    private final String applicationNamespaceName = "http://tempuri.org/";
    private final String MTOMping = "MTOMping";
    private final String Attachment = "Attachment";
    private final String SOURCE_IMAGE_FILE = "modules" + File.separator + "tests" + "mtom-image.jpg";
    private final String DESTINATION_IMAGE_FILE = "target" + File.separator + "mtom-image1.jpg";
    private final String PING_OPERATION_NAME = "ping";
    private Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    int serverPort = 8060;
    long sourceLength;

    public MTOMRMTest() {
        super("MTOMRMTest");
    }

    public void setUp() throws AxisFault {
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "test-classes" + File.separator + "server_mtom_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
        AxisService axisService = axisConfiguration.getService("RMSampleService");
        AxisOperation operation = AxisOperationFactory.getAxisOperation((int)10);
        operation.setMessageReceiver((MessageReceiver)new MTOMTestMessageReceiver());
        operation.setName(new QName("MTOMping"));
        axisService.addOperation(operation);
        AxisOperation pingOperation = axisService.getOperation(new QName("ping"));
        if (pingOperation == null) {
            throw new AxisFault("Cant find the ping operation");
        }
        operation.setRemainingPhasesInFlow(pingOperation.getRemainingPhasesInFlow());
        String serverPortStr = this.getTestProperty("test.server.port");
        if (serverPortStr != null) {
            try {
                this.serverPort = Integer.parseInt(serverPortStr);
            }
            catch (NumberFormatException e) {
                this.log.error((Object)e);
            }
        }
        this.httpServer = new SimpleHTTPServer(configContext, this.serverPort);
        this.httpServer.start();
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            throw new SandeshaException("sleep interupted");
        }
    }

    public void tearDown() throws SandeshaException {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            throw new SandeshaException("sleep interupted");
        }
    }

    public void testMTOMPing() throws AxisFault, InterruptedException {
    }

    private OMElement getMTOMPingOMBlock() throws AxisFault {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace namespace = fac.createOMNamespace("http://tempuri.org/", "ns1");
        OMElement pingElem = fac.createOMElement("MTOMping", namespace);
        OMElement attachElem = fac.createOMElement("Attachment", namespace);
        File file = new File(this.SOURCE_IMAGE_FILE);
        MTOMRMTest.assertTrue((boolean)file.exists());
        this.sourceLength = file.length();
        FileDataSource dataSource = new FileDataSource(file);
        MTOMRMTest.assertNotNull((Object)dataSource);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        OMText textData = fac.createOMText((Object)dataHandler, true);
        attachElem.addChild((OMNode)textData);
        pingElem.addChild((OMNode)attachElem);
        return pingElem;
    }

    private void doInvocation(MessageContext mc) throws AxisFault {
        SOAPEnvelope envelope = mc.getEnvelope();
        MTOMRMTest.assertNotNull((Object)envelope);
        SOAPBody body = envelope.getBody();
        OMElement payload = body.getFirstElement();
        OMElement attachmentElem = payload.getFirstChildWithName(new QName("http://tempuri.org/", "Attachment"));
        if (attachmentElem == null) {
            throw new AxisFault("'Attachment' element is not present as a child of the 'Ping' element");
        }
        OMText binaryElem = (OMText)attachmentElem.getFirstOMChild();
        binaryElem.setOptimize(true);
        DataHandler dataHandler = (DataHandler)binaryElem.getDataHandler();
        try {
            File destinationFile = new File(this.DESTINATION_IMAGE_FILE);
            if (destinationFile.exists()) {
                destinationFile.delete();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(this.DESTINATION_IMAGE_FILE);
            InputStream inputStream = dataHandler.getDataSource().getInputStream();
            byte[] bytes = new byte[5000];
            int length = inputStream.read(bytes);
            fileOutputStream.write(bytes, 0, length);
            fileOutputStream.close();
            destinationFile = new File(this.DESTINATION_IMAGE_FILE);
            MTOMRMTest.assertTrue((boolean)destinationFile.exists());
            long destLength = destinationFile.length();
            MTOMRMTest.assertEquals((long)this.sourceLength, (long)destLength);
            destinationFile.delete();
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    private class MTOMTestMessageReceiver
    extends RawXMLINOnlyMessageReceiver {
        private MTOMTestMessageReceiver() {
        }

        public void invokeBusinessLogic(MessageContext msgContext) throws AxisFault {
            try {
                MTOMRMTest.this.doInvocation(msgContext);
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

