/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.scenarios;

import java.io.File;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.client.async.AxisCallback;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class OptionalReliabilityTest
extends SandeshaTestCase {
    public OptionalReliabilityTest() {
        super("OptionalReliabilityTest");
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "server";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "server" + File.separator + "server_axis2.xml";
        this.startServer(repoPath, axis2_xml);
    }

    public void testPing() throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        Options clientOptions = new Options();
        clientOptions.setAction(this.pingAction);
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE, (Object)"true");
        serviceClient.setOptions(clientOptions);
        serviceClient.fireAndForget(this.getPingOMBlock("echo1"));
        SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
        OptionalReliabilityTest.assertTrue((boolean)sequenceReport.getCompletedMessages().isEmpty());
        List inboundReports = SandeshaClient.getIncomingSequenceReports((ConfigurationContext)configContext);
        OptionalReliabilityTest.assertTrue((boolean)inboundReports.isEmpty());
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    public void testSyncEcho() throws AxisFault {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE, (Object)"true");
        serviceClient.setOptions(clientOptions);
        OMElement result = serviceClient.sendReceive(OptionalReliabilityTest.getEchoOMBlock("echo1", "sync"));
        String echoStr = this.checkEchoOMBlock(result);
        OptionalReliabilityTest.assertEquals((String)echoStr, (String)"echo1");
        SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
        OptionalReliabilityTest.assertTrue((boolean)sequenceReport.getCompletedMessages().isEmpty());
        List inboundReports = SandeshaClient.getIncomingSequenceReports((ConfigurationContext)configContext);
        OptionalReliabilityTest.assertTrue((boolean)inboundReports.isEmpty());
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }

    public void testAsyncEcho() throws AxisFault, InterruptedException {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "client";
        String axis2_xml = "target" + File.separator + "repos" + File.separator + "client" + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        Options clientOptions = new Options();
        clientOptions.setAction(this.echoAction);
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE, (Object)"true");
        clientOptions.setTransportInProtocol("http");
        clientOptions.setUseSeparateListener(true);
        serviceClient.setOptions(clientOptions);
        SandeshaTestCase.TestCallback callback1 = new SandeshaTestCase.TestCallback(this, "Callback 1");
        serviceClient.sendReceiveNonBlocking(OptionalReliabilityTest.getEchoOMBlock("echo1", "async"), (AxisCallback)callback1);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                OptionalReliabilityTest.assertTrue((boolean)sequenceReport.getCompletedMessages().isEmpty());
                OptionalReliabilityTest.assertTrue((boolean)callback1.isComplete());
                OptionalReliabilityTest.assertEquals((String)callback1.getResult(), (String)"echo1");
                List inboundReports = SandeshaClient.getIncomingSequenceReports((ConfigurationContext)configContext);
                OptionalReliabilityTest.assertTrue((boolean)inboundReports.isEmpty());
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

