/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.security;

import java.io.File;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.sandesha2.SandeshaTestCase;
import org.apache.sandesha2.client.SandeshaClient;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SequenceReport;

public class SecurityTest
extends SandeshaTestCase {
    public SecurityTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        String repoPath = "target" + File.separator + "repos" + File.separator + "secure-server";
        String axis2_xml = repoPath + File.separator + "server_axis2.xml";
        this.startServer(repoPath, axis2_xml);
    }

    public void testCreateSequence() throws Exception {
        this.createSequence("Spec_2005_02");
        this.createSequence("Spec_2007_02");
    }

    public void createSequence(String spec) throws Exception {
        String to = "http://127.0.0.1:" + this.serverPort + "/axis2/services/RMSampleService";
        String repoPath = "target" + File.separator + "repos" + File.separator + "secure-client";
        String axis2_xml = repoPath + File.separator + "client_axis2.xml";
        ConfigurationContext configContext = ConfigurationContextFactory.createConfigurationContextFromFileSystem((String)repoPath, (String)axis2_xml);
        ServiceClient serviceClient = new ServiceClient(configContext, null);
        Options clientOptions = new Options();
        clientOptions.setTo(new EndpointReference(to));
        clientOptions.setProperty(SandeshaClientConstants.RM_SPEC_VERSION, (Object)spec);
        serviceClient.setOptions(clientOptions);
        String sequenceKey = SandeshaClient.createSequence((ServiceClient)serviceClient, (boolean)false);
        clientOptions.setProperty(SandeshaClientConstants.SEQUENCE_KEY, (Object)sequenceKey);
        long limit = System.currentTimeMillis() + (long)this.waitTime;
        Error lastError = null;
        while (System.currentTimeMillis() < limit) {
            Thread.sleep(this.tickTime);
            try {
                SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport((ServiceClient)serviceClient);
                SecurityTest.assertNotNull((Object)sequenceReport);
                SecurityTest.assertTrue((boolean)sequenceReport.isSecureSequence());
                lastError = null;
                break;
            }
            catch (Error e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
        configContext.getListenerManager().stop();
        serviceClient.cleanup();
    }
}

